/*
 * Copyright (C) 2009 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package bluetooth.Trump;

import java.io.IOException;
import java.io.OptionalDataException;
import java.io.StreamCorruptedException;

import android.app.ActionBar;
import android.app.Activity;
import android.app.AlertDialog;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.text.Layout;
import android.util.Log;
import android.view.Gravity;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.TextView;
import android.widget.Toast;

/**
 * This is the main Activity that displays the current chat session.
 */
public class BluetoothTrump extends Activity implements View.OnClickListener{
    // Debugging
    private static final String TAG = "BluetoothTrump";
    private static final boolean D = true;

    // Message types sent from the BluetoothChatService Handler
    public static final int MESSAGE_STATE_CHANGE = 1;
    public static final int MESSAGE_READ = 2;
    public static final int MESSAGE_WRITE = 3;
    public static final int MESSAGE_DEVICE_NAME = 4;
    public static final int MESSAGE_TOAST = 5;


    // Key names received from the BluetoothChatService Handler
    public static final String DEVICE_NAME = "device_name";
    public static final String TOAST = "toast";

    // Intent request codes
    private static final int REQUEST_CONNECT_DEVICE_SECURE = 1;
    private static final int REQUEST_CONNECT_DEVICE_INSECURE = 2;
    private static final int REQUEST_ENABLE_BT = 3;

    // Layout Views
    private ListView mConversationView;
    private EditText mOutEditText;
    private Button mStartButton;
    private Button mDrawButton;
    private Button mPassButton;
    
    private ViewInfo viewinfo;
    private int myPlayerNumber;
    private int opponentPlayerNumber;
    AlertDialog alertDialog;

    // Name of the connected device
    private String mConnectedDeviceName = null;
    // Array adapter for the conversation thread
    private ArrayAdapter<String> mConversationArrayAdapter;
    // String buffer for outgoing messages
    private StringBuffer mOutStringBuffer;
    // Local Bluetooth adapter
    private BluetoothAdapter mBluetoothAdapter = null;
    // Member object for the chat services
    private BluetoothTrumpService mChatService = null;
    
    
    
    //
	private final int FP = ViewGroup.LayoutParams.FILL_PARENT; 
	private final int WC = ViewGroup.LayoutParams.WRAP_CONTENT; 
	
	int spade[] = new int[14];
	int heart[] = new int[14];
	int dia[] = new int[14];
	int clover[] = new int[14];
	int cardback = 0;
	int playerHandCounter = 1; //D̃J[ĥ炵ɎgJE^@
	int enemyHandCounter = 1; //

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if(D) Log.e(TAG, "+++ ON CREATE +++");

        // Set up the window layout
        setContentView(R.layout.main);

        // Get local Bluetooth adapter
        mBluetoothAdapter = BluetoothAdapter.getDefaultAdapter();

        // If the adapter is null, then Bluetooth is not supported
        if (mBluetoothAdapter == null) {
            Toast.makeText(this, "Bluetooth is not available", Toast.LENGTH_LONG).show();
            finish();
            return;
        }
    }

    @Override
    public void onStart() {
        super.onStart();
        if(D) Log.e(TAG, "++ ON START ++");

        // If BT is not on, request that it be enabled.
        // setupChat() will then be called during onActivityResult
        if (!mBluetoothAdapter.isEnabled()) {
            Intent enableIntent = new Intent(BluetoothAdapter.ACTION_REQUEST_ENABLE);
            startActivityForResult(enableIntent, REQUEST_ENABLE_BT);
        // Otherwise, setup the chat session
        } else {
            if (mChatService == null) setupChat();
        }
    }

    @Override
    public synchronized void onResume() {
        super.onResume();
        if(D) Log.e(TAG, "+ ON RESUME +");

        // Performing this check in onResume() covers the case in which BT was
        // not enabled during onStart(), so we were paused to enable it...
        // onResume() will be called when ACTION_REQUEST_ENABLE activity returns.
        if (mChatService != null) {
            // Only if the state is STATE_NONE, do we know that we haven't started already
            if (mChatService.getState() == BluetoothTrumpService.STATE_NONE) {
              // Start the Bluetooth chat services
              mChatService.start();
            }
        }
    }

    private void setupChat() {
        Log.d(TAG, "setupChat()");

        mStartButton = (Button) findViewById(R.id.button_start);
        mStartButton.setOnClickListener(this);
        
        // Initialize the BluetoothChatService to perform bluetooth connections
        mChatService = new BluetoothTrumpService(this, mHandler);

        // Initialize the buffer for outgoing messages
        mOutStringBuffer = new StringBuffer("");
        
        this.imagemapping();
        this.alertDialog = new AlertDialog.Builder(this).create();
  }
    
    
    
    public void onClick(View v){
    	
    	if(v==mStartButton){
    		if (mChatService.getState() != BluetoothTrumpService.STATE_CONNECTED) {
                Toast.makeText(this, R.string.not_connected, Toast.LENGTH_SHORT).show();
                return;
    		}
    		if(D) Log.i(TAG, "GAME START YOU ARE PLAYER 1");
    		this.myPlayerNumber=1;
    		this.opponentPlayerNumber=2;
    		this.viewinfo = new ViewInfo();
    		this.viewinfo.firstDraw(myPlayerNumber);
    		this.viewinfo.firstDraw(opponentPlayerNumber);
    		sendMessage(viewinfo);
    		viewinfo.setStart(false);
    		show(this.viewinfo,this.myPlayerNumber);
            return;
    	}
    	

    	boolean[] turnDraw;
		boolean[] turnPass;

    	if(v==mDrawButton){
    		if(D) Log.e(TAG, "Clicked DrawButton");
    		//clicked draw button
    		turnDraw=viewinfo.getTurnDraw();
    		turnPass=viewinfo.getTurnPass();

    		if(turnDraw[opponentPlayerNumber] || turnPass[opponentPlayerNumber]){
    			viewinfo.drawCard(myPlayerNumber);
    			if(viewinfo.calculate(myPlayerNumber)>21){
    				turnPass[myPlayerNumber]=true;
    				viewinfo.setTurnPass(turnPass);
    			}
    		}
    		
    		turnDraw[myPlayerNumber]=true;
			viewinfo.setTurnDraw(turnDraw);
			sendMessage(viewinfo);

    		mDrawButton.setEnabled(false);
    		mPassButton.setEnabled(false);

    	}else if(v==mPassButton){
    		if(D) Log.e(TAG, "Clicked PassButton");
    		//clicked pass button
    		turnDraw=viewinfo.getTurnDraw();
    		turnPass=viewinfo.getTurnPass();

    		if(turnPass[opponentPlayerNumber]){
    			showresult();
    		}
    		
			turnPass[myPlayerNumber]=true;
			viewinfo.setTurnPass(turnPass);
    		sendMessage(viewinfo);
    		
    		mDrawButton.setEnabled(false);
    		mPassButton.setEnabled(false);
    	}
    	
    }
    
    public void reStart(){
    	setContentView(R.layout.main);
    	mStartButton = (Button) findViewById(R.id.button_start);
        mStartButton.setOnClickListener(this);
    }

    @Override
    public synchronized void onPause() {
        super.onPause();
        if(D) Log.e(TAG, "- ON PAUSE -");
    }

    @Override
    public void onStop() {
        super.onStop();
        if(D) Log.e(TAG, "-- ON STOP --");
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        // Stop the Bluetooth chat services
        if (mChatService != null) mChatService.stop();
        if(D) Log.e(TAG, "--- ON DESTROY ---");
    }

    private void ensureDiscoverable() {
        if(D) Log.d(TAG, "ensure discoverable");
        if (mBluetoothAdapter.getScanMode() !=
            BluetoothAdapter.SCAN_MODE_CONNECTABLE_DISCOVERABLE) {
            Intent discoverableIntent = new Intent(BluetoothAdapter.ACTION_REQUEST_DISCOVERABLE);
            discoverableIntent.putExtra(BluetoothAdapter.EXTRA_DISCOVERABLE_DURATION, 300);
            startActivity(discoverableIntent);
        }
    }

    /**
     * Sends a message.
     * @param message  A string of text to send.
     */
    private void sendMessage(String message) {
        // Check that we're actually connected before trying anything
    	if (mChatService.getState() != BluetoothTrumpService.STATE_CONNECTED) {
            Toast.makeText(this, R.string.not_connected, Toast.LENGTH_SHORT).show();
            return;
        }

        // Check that there's actually something to send
        if (message.length() > 0) {
            // Get the message bytes and tell the BluetoothChatService to write
            byte[] send = message.getBytes();
            mChatService.write(send);

            // Reset out string buffer to zero and clear the edit text field
            mOutStringBuffer.setLength(0);
            mOutEditText.setText(mOutStringBuffer);
        }
    }
    
    private void sendMessage(ViewInfo message) {
        // Check that we're actually connected before trying anything
        if (mChatService.getState() != BluetoothTrumpService.STATE_CONNECTED) {
            Toast.makeText(this, R.string.not_connected, Toast.LENGTH_SHORT).show();
            return;
        }


        // Get the message bytes and tell the BluetoothChatService to write
        byte[] send;
		try {
			send = ByteArray.fromObject(message);
			mChatService.write(send);
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
    }

    public void receiveMessage(ViewInfo vi){
    	
    	this.viewinfo=vi;
    	
    	if(viewinfo.getStart()){
    		if(D) Log.i(TAG, "GAME START YOU ARE PLAYER 2");
    		this.myPlayerNumber=2;
    		this.opponentPlayerNumber=1;
    		viewinfo.setStart(false);
    		alertDialog.dismiss();
    		show(this.viewinfo,this.myPlayerNumber);
    		
    	}else{
    		boolean[] turnDraw = viewinfo.getTurnDraw();
    		boolean[] turnPass = viewinfo.getTurnPass();
    		
    		if(turnDraw[myPlayerNumber] && turnDraw[opponentPlayerNumber]){
    			if(D) Log.i(TAG, "draw draw");
    			viewinfo.drawCard(myPlayerNumber);
    			if(viewinfo.calculate(myPlayerNumber)>21){
    				turnPass[myPlayerNumber]=true;
    				viewinfo.setTurnPass(turnPass);
    			}
    			showview();
    			turnDraw[myPlayerNumber]=false;
    			turnDraw[opponentPlayerNumber]=false;
    			viewinfo.setTurnDraw(turnDraw);
    			sendMessage(viewinfo);
    		}
    		
    		if(!turnDraw[myPlayerNumber] && !turnDraw[opponentPlayerNumber]){
    			if(D) Log.i(TAG, "!draw !draw");
    			showview();
    		}
    		
    		if(turnPass[myPlayerNumber] && turnDraw[opponentPlayerNumber]){
    			if(D) Log.i(TAG, "pass draw");
    			showview();
    			turnDraw[opponentPlayerNumber]=false;
    			viewinfo.setTurnDraw(turnDraw);
    			sendMessage(viewinfo);
    		}
    		
    		if(turnPass[myPlayerNumber] && turnPass[opponentPlayerNumber]){
    			if(D) Log.i(TAG, "pass pass");
    			showresult();
    		}
    		
    		if(turnDraw[myPlayerNumber] && turnPass[opponentPlayerNumber]){
    			if(D) Log.i(TAG, "draw pass");
    			viewinfo.drawCard(myPlayerNumber);
    			if(viewinfo.calculate(myPlayerNumber)>21){
    				turnPass[myPlayerNumber]=true;
    				viewinfo.setTurnPass(turnPass);
    			}
    			showview();
    			sendMessage(viewinfo);
    		}
    	
    		if(!turnPass[myPlayerNumber]){
    			mDrawButton.setEnabled(true);
    			mPassButton.setEnabled(true);
    		}
    		
    	}
    	

    }

    public void showview(){
    	if(D) {
    		Log.i(TAG, "me");
    		viewinfo.showcard(myPlayerNumber);
    		Log.i(TAG, "opponent");
    		viewinfo.showcard(opponentPlayerNumber);
    	}
    	
    	show(this.viewinfo,this.myPlayerNumber);
    	
    }
    
    public void showresult(){
    	if(D) {
    		Log.i(TAG, "result me");
    		viewinfo.showcard(myPlayerNumber);
    		Log.i(TAG, "result opponent");
    		viewinfo.showcard(opponentPlayerNumber);
    	}
    	result(this.viewinfo,this.myPlayerNumber);
    	AlertDialog.Builder alertDialogBuilder = new AlertDialog.Builder(this);
    	alertDialogBuilder.setTitle(viewinfo.result(myPlayerNumber));
    	alertDialogBuilder.setMessage("ȂF"+viewinfo.calculate(myPlayerNumber)+"\n"+"āF"+viewinfo.calculate(opponentPlayerNumber));
    	alertDialogBuilder.setPositiveButton("Đ",
    			new DialogInterface.OnClickListener(){
    		public void onClick(DialogInterface dialog, int which){
    			reStart();
    		}
    	});
    	alertDialogBuilder.setNegativeButton("I",
    			new DialogInterface.OnClickListener(){
    		public void onClick(DialogInterface dialog, int which){
    			finish();
    		}
    	});
    	
    	alertDialogBuilder.setCancelable(false);
    	alertDialog = alertDialogBuilder.create();
    	alertDialog.getWindow().setFlags(0, WindowManager.LayoutParams.FLAG_DIM_BEHIND);
    	alertDialog.show();
    	
    }


    private final void setStatus(int resId) {
        final ActionBar actionBar = getActionBar();
        actionBar.setSubtitle(resId);
    }

    private final void setStatus(CharSequence subTitle) {
        final ActionBar actionBar = getActionBar();
        actionBar.setSubtitle(subTitle);
    }

    // The Handler that gets information back from the BluetoothChatService
    private final Handler mHandler = new Handler() {
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
            case MESSAGE_STATE_CHANGE:
                if(D) Log.i(TAG, "MESSAGE_STATE_CHANGE: " + msg.arg1);
                switch (msg.arg1) {
                case BluetoothTrumpService.STATE_CONNECTED:
                    setStatus(getString(R.string.title_connected_to, mConnectedDeviceName));
                    //mConversationArrayAdapter.clear();
                    break;
                case BluetoothTrumpService.STATE_CONNECTING:
                    setStatus(R.string.title_connecting);
                    break;
                case BluetoothTrumpService.STATE_LISTEN:
                case BluetoothTrumpService.STATE_NONE:
                    setStatus(R.string.title_not_connected);
                    break;
                    
                }
                break;
            case MESSAGE_WRITE:
            	/*
            	byte[] writeBuf = (byte[]) msg.obj;
                // construct a string from the buffer
                String writeMessage = new String(writeBuf);
                mConversationArrayAdapter.add("Me:  " + writeMessage);
                */
                break;
                
            case MESSAGE_READ:
            	ViewInfo viewinfo;
				try {
					viewinfo = (ViewInfo)ByteArray.toObject((byte [])msg.obj);
					receiveMessage(viewinfo);
				} catch (OptionalDataException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (StreamCorruptedException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (ClassNotFoundException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
				
            	/*
            	byte[] readBuf = (byte[]) msg.obj;
                // construct a string from the valid bytes in the buffer
                String readMessage = new String(readBuf, 0, msg.arg1);
                mConversationArrayAdapter.add(mConnectedDeviceName+":  " + readMessage);
                */
                break;
                
            case MESSAGE_DEVICE_NAME:
                // save the connected device's name
                mConnectedDeviceName = msg.getData().getString(DEVICE_NAME);
                Toast.makeText(getApplicationContext(), "Connected to "
                               + mConnectedDeviceName, Toast.LENGTH_SHORT).show();
                break;
            case MESSAGE_TOAST:
                Toast.makeText(getApplicationContext(), msg.getData().getString(TOAST),
                               Toast.LENGTH_SHORT).show();
                break;
            
            }
        }
    };

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if(D) Log.d(TAG, "onActivityResult " + resultCode);
        switch (requestCode) {
        case REQUEST_CONNECT_DEVICE_SECURE:
            // When DeviceListActivity returns with a device to connect
            if (resultCode == Activity.RESULT_OK) {
                connectDevice(data, true);
            }
            break;
        case REQUEST_CONNECT_DEVICE_INSECURE:
            // When DeviceListActivity returns with a device to connect
            if (resultCode == Activity.RESULT_OK) {
                connectDevice(data, false);
            }
            break;
        case REQUEST_ENABLE_BT:
            // When the request to enable Bluetooth returns
            if (resultCode == Activity.RESULT_OK) {
                // Bluetooth is now enabled, so set up a chat session
                setupChat();
            } else {
                // User did not enable Bluetooth or an error occurred
                Log.d(TAG, "BT not enabled");
                Toast.makeText(this, R.string.bt_not_enabled_leaving, Toast.LENGTH_SHORT).show();
                finish();
            }
        }
    }

    
    private void connectDevice(Intent data, boolean secure) {
        // Get the device MAC address
        String address = data.getExtras()
            .getString(DeviceListActivity.EXTRA_DEVICE_ADDRESS);
        // Get the BluetoothDevice object
        BluetoothDevice device = mBluetoothAdapter.getRemoteDevice(address);
        // Attempt to connect to the device
        mChatService.connect(device, secure);
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        MenuInflater inflater = getMenuInflater();
        inflater.inflate(R.menu.option_menu, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        Intent serverIntent = null;
        switch (item.getItemId()) {
        case R.id.secure_connect_scan:
            // Launch the DeviceListActivity to see devices and do scan
            serverIntent = new Intent(this, DeviceListActivity.class);
            startActivityForResult(serverIntent, REQUEST_CONNECT_DEVICE_SECURE);
            return true;
        case R.id.insecure_connect_scan:
            // Launch the DeviceListActivity to see devices and do scan
        	serverIntent = new Intent(this, DeviceListActivity.class);
            startActivityForResult(serverIntent, REQUEST_CONNECT_DEVICE_INSECURE);
            return true;
        case R.id.discoverable:
            // Ensure this device is discoverable by others
            ensureDiscoverable();
            return true;
        }
        return false;
    }
    
    
    
    //////////////////////////////
    /////content view methods/////
    //////////////////////////////
    
    
	private FrameLayout.LayoutParams createEnemyParam(int w, int h){ //Dzû߂̃p[^
		FrameLayout.LayoutParams fl = new FrameLayout.LayoutParams(w, h);
		fl.leftMargin = 27*enemyHandCounter;
		enemyHandCounter++;
		return fl;
	}
	
	private FrameLayout.LayoutParams CreateMyParam(int w, int h){ //Dzû߂̃p[^
		FrameLayout.LayoutParams fl = new FrameLayout.LayoutParams(w, h);
		fl.leftMargin = 27*playerHandCounter;
		playerHandCounter++;
		return fl;
	}
	
    private LinearLayout.LayoutParams createLinearParam(int w, int h){ //linearLayout̊{p[^
        return new LinearLayout.LayoutParams(w, h);
    }
    
    
    
	public void show(ViewInfo viewinfo, int playernumber){ //S̕\n
		setContentView(R.layout.card_view);
    	LinearLayout Layout = (LinearLayout) findViewById(R.id.mainLayout);
    	//LinearLayout Layout = new LinearLayout(this);
		//Layout.setGravity(Gravity.CENTER_HORIZONTAL);
		//Layout.setOrientation(LinearLayout.VERTICAL);
		
		FrameLayout enemy = enemycount(viewinfo, playernumber);
		
		ViewGroup parent1 = (ViewGroup)enemy.getParent(); 
		if ( parent1 != null ) {
			parent1.removeView(enemy);
		}
		
		    LinearLayout button = buttonLayout();
		    
		    ViewGroup parent2 = (ViewGroup)button.getParent(); 
		    if ( parent2 != null ) {
		        parent2.removeView(button);
		    }
			
			FrameLayout hand = handsort(viewinfo, playernumber);
		    
		    ViewGroup parent3 = (ViewGroup)hand.getParent();
		    if ( parent3 != null ) {
		        parent3.removeView(hand);
		    }//layout̓q̍ۂɕKvȏ
		    
		    
		    TextView emptyView1 = new TextView(this);
		    TextView emptyView2 = new TextView(this);
		    //Layout.setWeightSum(10);
		    
		    LinearLayout.LayoutParams cardEdit = createLinearParam(WC,WC);
		    cardEdit.weight=3;
		    LinearLayout.LayoutParams buttonEdit = createLinearParam(WC, WC);
		    //marginEdit.topMargin = 100;//GDƃ{^C{^ƎD̃CAEg
		    buttonEdit.weight=2;
		    LinearLayout.LayoutParams emptyEdit = createLinearParam(WC, WC);
		    emptyEdit.weight=1;

		    
		    Layout.addView(enemy, cardEdit);
		    Layout.addView(emptyView1,emptyEdit);
		    Layout.addView(button, buttonEdit);
		    Layout.addView(emptyView2,emptyEdit);
		    Layout.addView(hand, cardEdit);
		    
		    setContentView(Layout);
	}
	
	public void result(ViewInfo viewinfo, int playernumber){ //S̕\n
		 LinearLayout Layout = new LinearLayout(this);
			Layout.setGravity(Gravity.CENTER_HORIZONTAL);
			Layout.setOrientation(LinearLayout.VERTICAL);
		    
		    FrameLayout enemy = handsort(viewinfo, (3-playernumber));
		    
		    ViewGroup parent1 = (ViewGroup)enemy.getParent(); 
		    if ( parent1 != null ) {
		        parent1.removeView(enemy);
		    }

		    LinearLayout button = buttonLayout();
		    
		    ViewGroup parent2 = (ViewGroup)button.getParent(); 
		    if ( parent2 != null ) {
		        parent2.removeView(button);
		    }
			
			FrameLayout hand = handsort(viewinfo, playernumber);
		    
		    ViewGroup parent3 = (ViewGroup)hand.getParent();
		    if ( parent3 != null ) {
		        parent3.removeView(hand);
		    }//layout̓q̍ۂɕKvȏ
		    
		    
		    TextView emptyView1 = new TextView(this);
		    TextView emptyView2 = new TextView(this);
		    //Layout.setWeightSum(10);
		    
		    LinearLayout.LayoutParams cardEdit = createLinearParam(WC,WC);
		    cardEdit.weight=3;
		    LinearLayout.LayoutParams buttonEdit = createLinearParam(WC, WC);
		    //marginEdit.topMargin = 100;//GDƃ{^C{^ƎD̃CAEg
		    buttonEdit.weight=2;
		    LinearLayout.LayoutParams emptyEdit = createLinearParam(WC, WC);
		    emptyEdit.weight=1;

		    
		    Layout.addView(enemy, cardEdit);
		    Layout.addView(emptyView1,emptyEdit);
		    Layout.addView(button, buttonEdit);
		    Layout.addView(emptyView2,emptyEdit);
		    Layout.addView(hand, cardEdit);
		    
		    setContentView(Layout);
	}
    
	
    
	public FrameLayout enemycount(ViewInfo viewinfo, int playernumber){ //̎DJEgĕ\
		
		FrameLayout enemyhand = new FrameLayout(this);
		
		int enemyCardNumber = 0;//̎D imagemappingɓ

		int spade[] = viewinfo.getSpade();
		int heart[] = viewinfo.getHeart();
		int dia[] = viewinfo.getDia();
		int clover[] = viewinfo.getClover();
		
		for(int i=1;i<14;i++){
			if(spade[i] == (3-playernumber)){
				enemyCardNumber++;
			}


			if(heart[i] == (3-playernumber)){
				enemyCardNumber++;
			}


			if(dia[i] == (3-playernumber)){
				enemyCardNumber++;
			}


			if(clover[i] == (3-playernumber)){
				enemyCardNumber++;
			}
		}
		
		for(int i=1;i<enemyCardNumber+1;i++){ //(̎D-1)̗ԂJ[hׂ
			ImageView enemycard = new ImageView(this);
			enemycard.setImageResource(cardback);
			enemyhand.addView(enemycard, createEnemyParam(WC, WC));
		}
		
		
		ImageView enemyOpenCard = new ImageView(this);
		
		
		for(int i=1;i<14;i++){
			if(spade[i] == (0-(3-playernumber))){
				enemyOpenAdd('s', i, enemyhand);
			}

			if(heart[i] == (0-(3-playernumber))){
				enemyOpenAdd('h', i, enemyhand);
			}

			if(dia[i] == (0-(3-playernumber))){
				enemyOpenAdd('d', i, enemyhand);
			}

			if(clover[i] == (0-(3-playernumber))){
				enemyOpenAdd('c', i, enemyhand);
			}
		}
		
		enemyHandCounter = 1;
			
		return enemyhand;
	}
	
	
	public void enemyOpenAdd(char mark, int number, FrameLayout enemyhand){
		ImageView enemyOpenCard = new ImageView(this);
		
		switch(mark){
		case 's':
			enemyOpenCard.setImageResource(spade[number]);
			enemyhand.addView(enemyOpenCard, createEnemyParam(WC, WC));
			break;
			
		case 'h':
			enemyOpenCard.setImageResource(heart[number]);
			enemyhand.addView(enemyOpenCard, createEnemyParam(WC, WC));
			break;
			
		case 'd':
			enemyOpenCard.setImageResource(dia[number]);
			enemyhand.addView(enemyOpenCard, createEnemyParam(WC, WC));
			break;
			
		default:
			enemyOpenCard.setImageResource(clover[number]);
			enemyhand.addView(enemyOpenCard, createEnemyParam(WC, WC));
		}

	}
	
	
	
	public LinearLayout buttonLayout(){ //CȂ{^̔zu
		LinearLayout bl = new LinearLayout(this);
		
	    LinearLayout.LayoutParams buttonMargin = createLinearParam(WC, WC);
	    buttonMargin.leftMargin = 100;//GDƃ{^C{^ƎD̃CAEg
	    
	    //Button draw = new Button(this);
	    //draw.setText("");
	    //Button ndraw = new Button(this);
	    //ndraw.setText("Ȃ");

	    mDrawButton = new Button(this);
        mPassButton = new Button(this);
        mDrawButton.setText("");
        mPassButton.setText("Ȃ");
        mDrawButton.setOnClickListener(this);
        mPassButton.setOnClickListener(this);
  
        if(this.viewinfo.getTurnPass()[myPlayerNumber]){
        	mDrawButton.setEnabled(false);
            mPassButton.setEnabled(false);
        }

	    bl.addView(mDrawButton, createLinearParam(WC, WC));
	    bl.addView(mPassButton, buttonMargin);
		
		return bl;
		
	}


	/*D*/
	public FrameLayout handsort(ViewInfo viewinfo,int playernumber){ //D𐮗ĕ\

		//D̐錾
		FrameLayout hand = new FrameLayout(this);
//		hand.setGravity(Gravity.BOTTOM);
//		hand.setGravity(Gravity.CENTER_HORIZONTAL);
//	    hand.setOrientation(LinearLayout.HORIZONTAL);
		setContentView(hand);
		
		int spade[] = viewinfo.getSpade();
		int heart[] = viewinfo.getHeart();
		int dia[] = viewinfo.getDia();
		int clover[] = viewinfo.getClover();

		/*珸ɕׂ*/

		for(int i=1;i<14;i++){
			
			if(spade[i] == playernumber){
				imageshow('s', i, hand);
			}


			if(heart[i] == playernumber){
				imageshow('h', i, hand);
			}


			if(dia[i] == playernumber){
				imageshow('d', i, hand);
			}


			if(clover[i] == playernumber){
				imageshow('c', i, hand);
			}
		}
		
		
		ImageView myOpenCard = new ImageView(this);
		
		
		for(int i=1;i<14;i++){
			if(spade[i] == (0-playernumber)){
				myOpenAdd('s', i, hand);
			}

			if(heart[i] == (0-playernumber)){
				myOpenAdd('h', i, hand);
			}

			if(dia[i] == (0-playernumber)){
				myOpenAdd('d', i, hand);
			}

			if(clover[i] == (0-playernumber)){
				myOpenAdd('c', i, hand);
			}
		}
		
		playerHandCounter = 1;
		
		return hand;
	}
	
	
	public void myOpenAdd(char mark, int number, FrameLayout enemyhand){
		ImageView myOpenCard = new ImageView(this);
		

			FrameLayout.LayoutParams fl = new FrameLayout.LayoutParams(WC, WC);
			fl.leftMargin = (27*playerHandCounter+200);
		
		switch(mark){
		case 's':
			myOpenCard.setImageResource(spade[number]);
			enemyhand.addView(myOpenCard, fl);
			break;
			
		case 'h':
			myOpenCard.setImageResource(heart[number]);
			enemyhand.addView(myOpenCard, fl);
			break;
			
		case 'd':
			myOpenCard.setImageResource(dia[number]);
			enemyhand.addView(myOpenCard, fl);
			break;
			
		default:
			myOpenCard.setImageResource(clover[number]);
			enemyhand.addView(myOpenCard, fl);
		}

	}

	

	public void imageshow(char mark, int number, FrameLayout hand){
		
		ImageView card = new ImageView(this);
		
		switch(mark){
		case 's':
			card.setImageResource(spade[number]);
			hand.addView(card, CreateMyParam(WC, WC));
			break;
			
		case 'h':
			card.setImageResource(heart[number]);
			hand.addView(card, CreateMyParam(WC, WC));
			break;
			
		case 'd':
			card.setImageResource(dia[number]);
			hand.addView(card, CreateMyParam(WC, WC));
			break;
			
		default:
			card.setImageResource(clover[number]);
			hand.addView(card, CreateMyParam(WC, WC));
		}
	}
	
	
	
	public void imagemapping(){ //摜int^zɑΉt郁\bh
		for(int i=1; i<10; i++){
			spade[i] = this.getResources().getIdentifier("s0"+(i), "drawable", this.getPackageName());
		}

		for(int i=10; i<14; i++){
			spade[i] = this.getResources().getIdentifier("s"+(i), "drawable", this.getPackageName());
		}
		
		
		for(int i=1; i<10; i++){
			heart[i] = this.getResources().getIdentifier("h0"+(i), "drawable", this.getPackageName());
		}

		for(int i=10; i<14; i++){
			heart[i] = this.getResources().getIdentifier("h"+(i), "drawable", this.getPackageName());
		}
		
		
		for(int i=1; i<10; i++){
			dia[i] = this.getResources().getIdentifier("d0"+(i), "drawable", this.getPackageName());
		}

		for(int i=10; i<14; i++){
			dia[i] = this.getResources().getIdentifier("d"+(i), "drawable", this.getPackageName());
		}
		
		
		for(int i=1; i<10; i++){
			clover[i] = this.getResources().getIdentifier("c0"+(i), "drawable", this.getPackageName());
		}

		for(int i=10; i<14; i++){
			clover[i] = this.getResources().getIdentifier("c"+(i), "drawable", this.getPackageName());
		}
		
		cardback = this.getResources().getIdentifier("z01", "drawable", this.getPackageName()); //Ԃ̃J[h
	}
}

